function [sol, err, it] = gs(a , x0, b, eps, maxiter)

xold = x0;
error = eps + 1;
iter = 0;

d = tril(a);
mat = - triu(a, 1);

while (iter < maxiter & error > eps)
  xnew =d \( mat*xold + b ) ;
  error = norm(xnew - xold);
  xold = xnew;
  iter = iter + 1;
end

err = error;
it = min(iter, maxiter);
sol = xnew;