%% H synarthsh ayth ylopoiei thn epanalhptikh me8odo syzhgwn
%% klisewn(Conjugate-Gradient) me arxikh timh panta to 0.
%% Kaleite me [sol err it] = cg(a, b, eps, maxiter), opou 
%% a = pinakas, b = deksio melos, 
%% eps = megisto apodekto sfalma sthn me8odo,  
%% maxiter = megistos ari8mos epanalhpsewn
%% sol = h lysh toy systhmatos
%% err = sfalma ths me8odou
%% iter = plh8os epnalhpsewn pou eginan
%%
%% yota@uth.gr

function [sol, err, it] = cg(a, b, eps, maxiter)

error = eps + 1;
d = diag(a);
xk = zeros(size(a,2), 1);
rk = b;
rk_tilda = rk ./ d;
pk = rk_tilda;
k = 0;
while (k < maxiter & error > eps)
    alphak = (rk_tilda' * rk) / (pk' * (a*pk));
    xkp1 = xk + alphak*pk;
    rkp1 = rk - alphak*(a*pk);
    rkp1_tilda = rkp1 ./ d;
    error = norm(rkp1,2);
    bk = (rkp1_tilda' * rkp1) / (rk_tilda' * rk);    
    k = k + 1;
    rk_tilda = rkp1_tilda;
    pk = rkp1_tilda + bk*pk;
    rk = rkp1;
    xk = xkp1;
end

err = error;
it = min(k, maxiter);
sol = xk;