function [xronos, error,it] = cg_run(nx, ny, c1, c2, c)

clear a x0 b eps maxiter err it sol 

[a,f] = elliptic(nx, ny, c1, c2, c);

sparse(a);

col = size(f,2);
x0=zeros(1,col);
eps = .5e-5;
maxiter = nx * ny;

if(nx<=5&ny<=5)
    nonzero(a);
end

tic;
[sol, err, it] = cg(a, f', eps, maxiter)
xronos = toc;
error = norm(a*sol-f');
plotsolution(nx,ny,sol);

fprintf('O xronos einai:%10.5f\n',xronos);
fprintf('To sfalma einai:%e\n',err);
fprintf('O ari8mos epanalipsewn einai:%d\n',it);