function [xronos,error]=luinc_run(nx,ny,c1,c2,c)

clear a f l u p ff z sol error

[a,f]=elliptic(nx,ny,c1,c2,c);

if (nx<=5&ny<=5)
    nonzero(a);
end

sa=sparse(a);
tic;

[l,u,p]=luinc(sa,.5e-5);
ff=p*f';

z=l\ff;
sol=u\z;

xronos=toc;
error=norm(a*sol-f');
plotsolution(nx,ny,sol);

