function [sol, err, it, xronos] = cg_run(nx,ny,c1,c2,c)
clear  a f l u p ff z sol error
clc;
[a,f]=elliptic(nx,ny,c1,c2,c);

if (nx<=5 && ny<=5)
nonzero(a);
end
tic;

xold = zeros(length(f),1);  %%midenikos pinakas se stili
eps=0.5e-5;
iter = 0;
error = eps + 1;
d = diag(a);
xk = zeros(size(a,2), 1);
rk = f';
rk_tilda = rk ./ d;
pk = rk_tilda;
k = 0;

while (k < nx*ny & error > eps)
    alphak = (rk_tilda' * rk) / (pk' * (a*pk));
    xkp1 = xk + alphak*pk;
    rkp1 = rk - alphak*(a*pk);
    rkp1_tilda = rkp1 ./ d;
    error = norm(rkp1,2);
    bk = (rkp1_tilda' * rkp1) / (rk_tilda' * rk);    
    k = k + 1;
    rk_tilda = rkp1_tilda;
    pk = rkp1_tilda + bk*pk;
    rk = rkp1;
    xk = xkp1;
end

err = error;
it = min(k, nx*ny);
sol = xk;

xronos=toc;
plotsolution(nx,ny,sol);