/* An example that demonstrates the use of the comma operator, 
   as well as operators' precedence */

#include <stdio.h>

int main (int argc, char *argv[]) {
	int input, output, temp;

	printf("Enter an integer: ");
	scanf("%d", &input);

	/* All expressions separated by commas are evaluated from left to right
	   and the result of the last expression is returned as the overall 
	   return value of the comma (,) operators */
	output = (input *= 2, input +=1, temp = 0);
	printf("Output equals %d, input equals %d\n", output, input);

	/* Let's try again, this time without the parentheses */
	printf("Enter again an integer: ");
	scanf("%d", &input);

	/* This time the result of the first expression is returned as the 
	   overall return value of the comma (,) operators. Why ? */
	output = input *= 2, input +=1, temp = 0;
	printf("Output equals %d, input equals %d\n", output, input);
	/* It has to do with operator precedence. = has higher priority than
	   commas. Therefore, the output = input*=2 is evaluated before the 
	   commas. */

	return(0);
}

