/* An example that demonstrates the use of the condition operator */

#include <stdio.h>

int main (int argc, char *argv[]) {
	int input, is_odd;

	printf("Enter an integer:");
	scanf("%d", &input);

	/* Observe how the condition operator is used to assign 2 or 0 to is_odd, 
	   depending on whether the condition is true or false. Observe also the
	   use of the modulo operator (%) */
	is_odd = ((input % 2) == 1) ? 2: 0;

	/* Now the condition operator is not used to assign value to a variable,
	   but rather to control the flow of the program (which of the printf
	   statements is going to be activated). Also observe how the value of 
	   the is_odd variable is used as a logical condition. 0 is considered 
	   false, anything else (2 in this case) is considered true */
	is_odd ? printf("The number (%d) is odd\n", input) : printf("The number (%d) is even\n", input);

	return(0);
}

