#include <stdio.h>
#include <stdlib.h>

/* Allocates a memory region large enough to store student
 * registration numbers for num_students students. Reads
 * the student registration numbers and stores them in the 
 * dynamically allocated memory area. Returns a pointer to 
 * the start of the memory area, or NULL if an error occured */
int *read_names(int num_students) {
  int *aem_array_ptr;
  int i;

/* Dynamically allocate memory */
  aem_array_ptr = (int *)malloc(sizeof(int) * num_students);
/* Always check to make sure that the memory allocation was
 * successful! */
  if (aem_array_ptr == NULL) {
    printf("Memory allocation problem\n");
    return(NULL);
  }

/* Read student registration numbers from the input and
 * store them in the dynamically allocated memory area.
 * You can either use pointer or array notation */
  for (i = 0; i < num_students; i++) {
    scanf("%d", aem_array_ptr + i);
/*    scanf("%d", &aem_array_ptr[i]);*/
  }

  return(aem_array_ptr);
}

int main(int argc, char *argv[]) {
  int howmany, i;
  int *table;

/* Read the number of students */
  printf("How many students? ");
  scanf("%d", &howmany);

/* Read student numbers and store them in a dynamically
 * allocated memory region. The pointer to the start
 * of the memory region is stored in table */
  table = read_names(howmany);
/* Check if table == NULL in case a memory allocation
 * error occured inside read_names */
  if (table == NULL) {
    printf("In main: Memory allocation problem. Exiting\n");
    return(1);
  }
  
/* Print the student registration numbers in table.
 * You can use either pointer or array notation */
  for (i = 0; i < howmany; i++) {
      printf("%d\n", *(table + i));
/*    printf("%d\n", table[i]);*/
  }

/* Never forget to free the dynamically allocated memory
 * of your program */
  free(table);
/* Remember that after a free the pointer is not changed, 
 * however it points to an invalid memory area. If you
 * want to be sure to remember that the pointer no longer
 * points to valid memory region, you can explicitly set 
 * it to NULL. However, free DOES NOT automatically set 
 * the pointer to NULL */
  table = NULL;

  return(0);
}
