#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUF_SIZE 101

/* The struct defines the data "object" of a student */
struct student {
	char *firstname;
	char *lastname;
	int aem;
};

/* We name struct student as a new data type, studentT */
typedef struct student studentT;

void clean_memory(studentT *array, int howmany) {
	int i;
	
/* Free the dynamically allocated memory pointed to by 
 * struct pointers first (or, in other words, free the 
 * memory pointed to by the innermost pointers FIRST) */
	for (i = 0; i < howmany; i++) {
		free((array+i)->firstname);
		free((array+i)->lastname);
	}
/* Then free the memory of students_array */
	free(array);
}

/* Allocates an array of 'howmany' studentT "objects".
 * Reads student data and fills them in the array.
 * Returns the pointer to the start of the dynamically
 * allocated array. Returns NULL in case of error. */
studentT *read_students(int howmany) {
	int i, error = 0;
	studentT *students_array;
	char buffer[BUF_SIZE]; /* Strings read by the keyboard are
	read in a buffer. Then, they are copied to a dynamically 
	allocated area with size exactly as required to store the
	characters read (using strdup). */
	char format_str[20];
 
	/* Generate dynamically the format string for scanf */
	sprintf(format_str, "%%%ds", BUF_SIZE-1);
	
	/* Allocate the memory required to store studentT structs,
	 * according to the number of students (howmany) */
	students_array = (studentT *)malloc(sizeof(studentT) * howmany);
	/* Always check if memory allocation was successful */
	if (students_array == NULL) {
		printf("Memory allocation problem for array\n");
		return(NULL);
	}
	
	/* For each student */
	for (i = 0; i < howmany; i++) {
		printf("Student %d\n", i);
		printf("Enter firstname:\n");
		/* Read first name to the buffer */
		scanf(format_str, buffer);
		/* Copy the string read to a dynamically allocated area
		 * with exactly the right size (all this is done easily 
		 * using strdup). Make the firstname field (pointer) of the
		 * respective element of students array point to the newly
		 * allocated area with the copy of the string. Note that 
		 * pointers notation is used. We could also write:
		 * students_array[i].firstname = ... */
		(students_array+i)->firstname = strdup(buffer);
		/* Check if the memory allocation in strdup was successful.
		 * If not, use the error flag to denote an error and exit 
		 * the loop */
		if ((students_array+i)->firstname == NULL) {
			error = 1;
			printf("Memory allocation error for firstname\n");
			break;
		}
		printf("Enter lastname:\n");
		/* Similarly for last name */
		scanf(format_str, buffer);
		(students_array+i)->lastname = strdup(buffer);
		/* Check if the memory allocation in strdup was successful.
		 * If not, use the error flag to denote an error and exit 
		 * the loop. However free firstname as well! */
		if ((students_array+i)->lastname == NULL) {
			error = 1;
			printf("Memory allocation error for lastname\n");
			free((students_array+i)->firstname);
			break;
		}
		printf("Enter AEM:\n");
		scanf("%d", &((students_array + i)->aem));
	}
	/* If you exited due to an error, free all memory dynamically 
	 * allocated prior to the error */ 
	if (error) {
		clean_memory(students_array, i);
		students_array = NULL;
	}
	return(students_array);

}

int main(int argc, char *argv[]) {
	int num_students, i;
	studentT *student_data;
	
	/* Read the number of students */
	printf("Enter number of students\n");
	scanf("%d", &num_students);
	
	/* Call read_students to read data for all students */
	student_data = read_students(num_students);
	/* Check if a memory allocation failed */
	if (student_data == NULL) {
		printf("Exiting due to a memory allocation error\n");
		return(1);
	}
	
	/* Print the data for all students. Notice that array notation
	 * is used. We could also use pointer notation */
	for (i = 0; i < num_students; i++) {
		printf("Student %d\n", i);
		printf("Firstname: %s\n", student_data[i].firstname);
		printf("Lastname: %s\n", student_data[i].lastname);
		printf("AEM: %d\n", student_data[i].aem);
	}
	
	clean_memory(student_data, num_students);
	
	return(0);
}