#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Dynamically allocate a new memory area large enough 
 * to store the concatenation of strings in str1 and 
 * str2. Create the concatenation of the two strings and
 * store it to the dynamically allocated memory region.
 * Return a pointer to the start of the memory region, or
 * NULL in case of error */
char *strAppend(const char *str1, const char *str2) {
	char *new_string;
	
/* Dynamically allocate a new memory area large enough to 
 * store the characters of the string in str1 plus the 
 * characters of the string in str2, plus 1 (for \0) */
	new_string = (char *)malloc(sizeof(char) * (strlen(str1)+strlen(str2)+1));
/* Always check for memory allocation problems and act accordingly */
	if (new_string == NULL) {
		printf("Oops, memory allocation problem\n");
		return(NULL);
	}
	
/* Copy the first string to the newly allocated area. Be 
 * carefull, new_string is not initialized, therefore it
 * would be a mistake to use strcat! */
	strcpy(new_string, str1);
/* Concatenate the string in str2 after the string already
 * stored in new_string by the previous strcpy. strcat takes
 * care of the termination character \0, you don't have to
 * add it yourself */
	strcat(new_string, str2);
	
	return(new_string);
}

/* Takes two strings as arguments from the command line, 
 * creates a new string which is the concatenation of those 
 * two and prints it */
int main (int argc, char *argv[]) {
	char *concatenated_string;

/* Check if the user has provided the required command-line
 * arguments. If not, exit, printing an informative message. 
 * Observe how we use argv[0] in the message to print the 
 * executable name */
	if (argc != 3) {
		printf("%s <1st string> <2nd string>\n", argv[0]);
		return(1);
	}

/* Use argv[1] and argv[2] (the pointers to the memory where
 * the 1st and 2nd command-line argument are stored) as arguments
 * to strAppend. Store the start of the dynamically allocated memory
 * area containing the concatenated string to a pointer */
	concatenated_string = strAppend(argv[1], argv[2]);
	if (concatenated_string == NULL) {
		printf("In main: memory allocation problem\n");
		return(1);
	}
/* Print the new string */	
	printf("New string = %s\n", concatenated_string);

/* Do not forget to free all dynamically allocated memory */	
	free(concatenated_string);
	return(0);
}
