#include <stdlib.h>
#include <stdio.h>

/* Similar to circular, singly linked list with sentinel, however 
 * now the list is doubly linked. Only the differences are highlighted
 * with comments */

/* Now each list node has also a pointer to the previous node */
struct list {
	int data;
	struct list *next;
	struct list *prev;
};

struct list *head;


void init_list() {
	head = (struct list *)malloc(sizeof(struct list));
	if (head == NULL) {
		printf("Memory allocation error in initialization\n");
		exit(1);
	}
	/* Both pointers of sentinel should point to itself on 
	 * initialization, as the list should behave as circular
	 * no matter whether you scan it forward (using the next
	 * pointers) or backwards (using the prev pointers) */
	head->next = head;
	head->prev = head;
}


void print_list () {
	struct list *current;
	/* Print the list both forward and backwards */
	printf("Print list\n");
	printf("Forward:\n");
	for (current = head->next; current != head; current = current->next) {
		printf("Node address %p, node data %d, node next %p, node prev %p\n", current, current->data, current->next, current->prev);	
	}
	printf("Reverse:\n");
	for (current = head->prev; current != head; current = current->prev) {
		printf("Node address %p, node data %d, node next %p, node prev %p\n", current, current->data, current->next, current->prev);	
	}

}

int find_node (int search_data) {
	struct list *current;
	
	head->data = search_data;
	for (current = head->next; current->data != search_data; current = current->next) {
	}
	if (current == head)
		return (0);
	else
		return (1);
}

int remove_node (int data_to_del) {
	struct list *current;
	
	head->data = data_to_del;
	/* We no longer need to remember the previous node when scanning
	 * the list, as we can find it using the prev pointer of the node
	 * to be removed */
	for (current = head->next; current->data != data_to_del; current = current->next) {
	}
	if (current == head)
		return(1);
	
	/* Take care of the prev pointer of the next node...
	 * ... and of the next pointer of the previous node 
	 * to bypass the node to be removed when moving both
	 * forward and backwards in the list */
	current->next->prev = current->prev;
	current->prev->next = current->next;
	
	free(current);
	return(0);
}


int add_node (int input_data) {
	struct list *new_node;
	
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	/* Fix the fields of the new node */
	new_node->data = input_data;
	/* The next of the new node will be the next of the sentinel */
	new_node->next = head->next;
	/* The prev of the new node will be the sentinel itself */
	new_node->prev = head;
	
	/* Now fix the pointers of neighbouring nodes in the list */ 
	/* The prev of the next of the new node should point to the new node */
	new_node->next->prev = new_node;
	/* The next of the previous node should point to the new node */
	new_node->prev->next = new_node;

	return(0);
}


void destroy_list(void) {
	free(head);
}


int main (int argc, char *argv[]) {
	int res;
	
	init_list();
		
	res = add_node(15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list();
	
	res = find_node(100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = remove_node(100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	destroy_list();
	return(0);	
}
