#include <stdlib.h>
#include <stdio.h>

/* The struct representing a list node */
struct list {
	int data;
	struct list *next;
};

/* List head. A global variable in this example */
struct list *head;

/* Initialization needs to be called before the first invocation 
 * of any lists function. The head of an empty list is NULL */
void init_list() {
	head = NULL;
}


/* Scans the list and prints the contents of its nodes */
void print_list () {
	struct list *current;
	
	/* Start from the node pointed to by head, and continue
	 * until you reach the end of the list (NULL next pointer) */
	for (current = head; current != NULL; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}


/* Add a new node, containing input_data. Returns 0 if 
   successful, 1 otherwise */
int add_node (int input_data) {
	struct list *new_node;
	
	/* Allocate memory for the new node */
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	/* Store the data in the data field of the node */
	new_node->data = input_data;
	
	/* Put the new node as the first node in the list */
	new_node->next = head;
	head = new_node;
	return(0);
}


void destroy_list() {
	struct list *current, *next;
	
/* The following IS WRONG!!! If you free the node pointed to by current,
 * you can no longer access the node, as you need to do in 
 * current = current->next which is executed each time right after the
 * free 

  	for (current = head; current != NULL; current = current->next) {
		free(current);
	}
*/

	/* This is the correct solution! */
	for (current = head; current != NULL;) {
		/* Before freeing the node pointed to by current, save its
		 * next node to next. */
		next = current->next;
		/* Now you no longer need any data from current and you can free it */
		free(current);
		/* Now make current point to the same node pointed to by next, that is
		 * the next node of the node you just deleted. This is equivalent to
		 * current = current->next, however it HAS to be done in 2 steps */
		current = next;
	}
	
	/* Indicate that the list is now empty */
	head = NULL;
}

int main (int argc, char *argv[]) {
	int res;
	
	init_list();
		
	res = add_node(15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	print_list();
	
	destroy_list();
	
	print_list();
	return(0);	
}
