#include <stdlib.h>
#include <stdio.h>

/* The struct representing a list node */
struct list {
	int data;
	struct list *next;
};

/* List head. A global variable in this example */
struct list *head;

/* Initialization needs to be called before the first invocation 
 * of any lists function. The head of an empty list is NULL */
void init_list() {
	head = NULL;
}


/* Scans the list and prints the contents of its nodes */
void print_list () {
	struct list *current;
	
	/* Start from the node pointed to by head, and continue
	 * until you reach the end of the list (NULL next pointer) */
	for (current = head; current != NULL; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}

/* Find if there is a node in the list containing search_data.
 * Return 0 if not found, 1 if found */
int find_node (int search_data) {
	struct list *current;
	
	/* Scan the list and stop if you have reached the end or if
	 * you have found the element you are looking for */
	for (current = head; current != NULL && current->data != search_data; current = current->next) {
	}
	/* Now we need to find out why we actually exited the loop */
	/* Did we reach the end? */
	if (current == NULL)
		return (0);
	else /* Or did we find the element? */
		return (1);
}


/* Look for a node containing data_to_del. If found, remove it.
 * Return 1 if the node was not found, 1 if the node was found
 * and deleted */
int remove_node (int data_to_del) {
	struct list *current, *previous;
	
	/* Apart from iterating through list nodes, at each step we need 
	 * to maintain a pointer to the previous node. This will be needed
	 * in the removal, if the node to be removed is found */
	for (previous = NULL, current = head; current != NULL && current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == NULL)
		return(1);
	/* We have found the node */
	/* Removing the first node of the list is a special case. Just
	 * make the head point the the next node of the node removed */
	if (current == head) {
		head = current->next;
	}
	else { /* Otherwise (not the first node of the list) bypass the
		    * node to be removed by making the next pointer of its 
		    * previous node in the list point to the next node of the
		    * node to be removed */
		previous->next = current->next;
	}
	/* Now free the memory allocated for the node that we just 
	 * removed and return 0 */
	free(current);
	return(0);
}


/* Add a new node, containing input_data. Returns 0 if 
   successful, 1 otherwise */
int add_node (int input_data) {
	struct list *new_node;
	
	/* Allocate memory for the new node */
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	/* Store the data in the data field of the node */
	new_node->data = input_data;
	
	/* Put the new node as the first node in the list */
	new_node->next = head;
	head = new_node;
	return(0);
}


int main (int argc, char *argv[]) {
	int res;
	
	init_list();
		
	res = add_node(15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list();
	
	res = find_node(100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = remove_node(100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	return(0);	
}
