#include <stdlib.h>
#include <stdio.h>

/* Similar to the singly linked list. List head is now not a global.
 * This means that: (a) It has to be passed to all list functions
 * as an argument, (b) When a list head is changed in a function we
 * return its new value as the return value of the function and (c)
 * of course now the same list functions can be used to manipulate
 * multiple lists, by changing the list head used as a parameter. */

/* We comment only differences from the singly linked list with
 * head represented by a global variable */

struct list {
	int data;
	struct list *next;
};


/* Initialization takes the no arguments. Returns NULL and its 
 * return value has to be saved to the respective list head 
 * being initialized */
struct list *init_list() {
	return(NULL);
}


/* Takes the list head as an argument */
void print_list (struct list *list_head) {
	struct list *current;
	
	for (current = list_head; current != NULL; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}

/* Takes list head as an additional argument */
int find_node (struct list *list_head, int search_data) {
	struct list *current;
	
	/* Scan the list and stop if you have reached the end or if
	 * you have found the element you are looking for */
	for (current = list_head; current != NULL && current->data != search_data; current = current->next) {
	}
	/* Now we need to find out why we actually exited the loop */
	/* Did we reach the end? */
	if (current == NULL)
		return (0);
	else /* Or did we find the element? */
		return (1);
}


/* Look for a node containing data_to_del. If found, remove it.
 * Return 1 if the node was not found, 0 if the node was found
 * and deleted */
/* Takes list head as a first argument. The outcome (1 if the not was
 * not found, 0 if it was found and deleted) is returned through the 
 * pointer parameter outcome. The function returns the new value of 
 * the head (it may change if the first node is removed) */
struct list *remove_node (struct list *list_head, int data_to_del, int *outcome) {
	struct list *current, *previous;
	
	/* Apart from iterating through list nodes, at each step we need 
	 * to maintain a pointer to the previous node. This will be needed
	 * in the removal, if the node to be removed is found */
	for (previous = NULL, current = list_head; current != NULL && current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == NULL) {
		/* Make the value in the memory area pointed to by outcome
		 * equal to one. List head has not changed, so return the same */
		*outcome = 1;
		return(list_head);
	}
	/* A node with the value we are looking for has been found. Set the 
	 * value in the memory area pointed to by outcome to 0 to indicate
	 * that */
	*outcome = 0;
	if (current == list_head) {
		/* New head is going to be the next of current */
		/* BE CAREFULL! This assignment will not have any effect
		 * outside this function. We NEED to return the new value 
		 * of list_head to the outside world as a return value of 
		 * the function */
		list_head = current->next;
	}
	else { /* Otherwise (not the first node of the list) bypass it */
		previous->next = current->next;
	}

	free(current);
	/* return the new value of list_head */
	return(list_head);
}


/* Add a new node, containing input_data. Takes the list head as 
 * a parameter. The value in the memory region pointed to by outcome
 * is set to 0 on success, 1 otherwise. The function returns the new
 * value of the list head. */
struct list *add_node (struct list *list_head, int input_data, int *outcome) {
	struct list *new_node;
	
	/* Allocate memory for the new node */
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		/* Set the memory pointed to by outcome to one and 
		 * return the previous value of list head */
		*outcome = 1;
		return(list_head);
	}
	
	new_node->data = input_data;
	
	new_node->next = list_head;
	/* BE CAREFULL! The following statement will have no effect outside
	 * the function. We NEED to RETURN the new value of list_head to 
	 * make it visible to the outside world */
	list_head = new_node;
	/* Set the value of the memory area pointed to by outcome to 0
	 * to indicate success */
	*outcome = 0;
	/* Return the new list head */
	return(list_head);
}


int main (int argc, char *argv[]) {
	/* List heads. Local variables of main in this example */
	struct list *list1, *list2;
	int res;
	
	list1 = init_list();
	list2 = init_list();
		
	list1 = add_node(list1, 15, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	list1 = add_node(list1, 20, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	list1 = add_node(list1, 1, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}

	list2 = add_node(list2, 16, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	list2 = add_node(list2, 21, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	list2 = add_node(list2, 2, &res);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	
	print_list(list1);
	print_list(list2);
	
	res = find_node(list1, 100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(list1, 15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = find_node(list2, 100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(list2, 21);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	
	list1 = remove_node(list1, 100, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	list1 = remove_node(list1, 1, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	list1 = remove_node(list1, 15, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	list1 = remove_node(list1, 20, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);


	list2 = remove_node(list2, 100, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	list2 = remove_node(list2, 2, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);
	
	list2 = remove_node(list2, 16, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);
	
	list2 = remove_node(list2, 21, &res);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);
	

	return(0);	
}
