#include <stdlib.h>
#include <stdio.h>

/* Similar to the singly linked list. List head is now not a global.
 * This means that: (a) It has to be passed to all list functions
 * as an argument, (b) When a list head is changed in a function we
 * pass it by reference (as a **) and return its new value through the 
 * argument (the main difference from multiple1 example) and (c)
 * of course now the same list functions can be used to manipulate
 * multiple lists, by changing the list head used as a parameter. */

/* We comment only differences from the singly linked list with
 * head represented by a global variable */


struct list {
	int data;
	struct list *next;
};


/* The address of list head is passed as an argument 
 * and is used to initialize list_head to NULL */
void init_list(struct list **list_head) {
	*list_head = NULL;
}


void print_list (struct list *list_head) {
	struct list *current;
	
	/* Start from the node pointed to by list_head */
	for (current = list_head; current != NULL; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}

/* List head is passed as an argument */
int find_node (struct list *list_head, int search_data) {
	struct list *current;
	
	/* Start from list_head */
	for (current = list_head; current != NULL && current->data != search_data; current = current->next) {
	}

	if (current == NULL)
		return (0);
	else 
		return (1);
}


/* Look for a node containing data_to_del. If found, remove it.
 * Return 1 if the node was not found, 1 if the node was found
 * and deleted. The address of list_head is passed as an argument 
 * and is used to change list_head to point to the the new head node */
int remove_node (struct list **list_head, int data_to_del) {
	struct list *current, *previous;
	
	/* Start from the node at the head of the list. Note that we pass
	 * the address of list_head in the function, therefore we need to 
	 * use * to find the node at the head of the list */
	for (previous = NULL, current = *list_head; current != NULL && current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == NULL)
		return(1);
	/* We have found the node */
	/* Removing the first node of the list is a special case. Just
	 * make the head point the the next node of the node removed */
	if (current == *list_head) {
		*list_head = current->next;
	}
	else {
		previous->next = current->next;
	}

	free(current);
	return(0);
}


/* Add a new node, containing input_data. Returns 0 if 
   successful, 1 otherwise. The address of the variable
   containing a pointer to the head node of the list is passed
   as an argument (**), so that the pointer to the head node can
   be changed from within the function */
int add_node (struct list **list_head, int input_data) {
	struct list *new_node;
	
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	new_node->data = input_data;
	
	/* Put the new node as the first node in the list */
	new_node->next = *list_head;
	*list_head = new_node;
	return(0);
}


int main (int argc, char *argv[]) {
	struct list *list1, *list2;
	int res;
	
	init_list(&list1);
	init_list(&list2);
		
	res = add_node(&list1, 15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list1, 20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list1, 1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list(list1);
	

	res = add_node(&list2, 16);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list2, 21);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list2, 2);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list(list2);

	
	res = find_node(list1, 100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(list1, 15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	
	res = find_node(list2, 100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(list2, 16);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	
	res = remove_node(&list1, 100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(&list1, 1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	res = remove_node(&list1, 15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	res = remove_node(&list1, 20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	

	res = remove_node(&list2, 100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(&list2, 2);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);
	
	res = remove_node(&list2, 16);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);
	
	res = remove_node(&list2, 21);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list2);

	
	return(0);	
}
