#include <stdlib.h>
#include <stdio.h>

/* Similar to singly-linked list, however this time with a sentinel. *
 * Only differences are highlighted */
struct list {
	int data;
	struct list *next;
};

struct list *head;

/* Now the initialization includes allocating memory for the 
 * node that will serve as the sentinel and making head point
 * to it */
void init_list() {
	head = (struct list *)malloc(sizeof(struct list));
	if (head == NULL) {
		printf("Memory allocation error in initialization\n");
		/* Terminate the program with return value 1 */
		exit(1);
	}
	head->next = NULL;
}


void print_list () {
	struct list *current;
	
	/* Start from head->next, as this is the first "real" node 
	 * of the list. head points to the sentinel */
	for (current = head->next; current != NULL; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}


int find_node (int search_data) {
	struct list *current;
	
	/* Once again, start from head->next */
	for (current = head->next; current != NULL && current->data != search_data; current = current->next) {
	}
	if (current == NULL)
		return (0);
	else
		return (1);
}


int remove_node (int data_to_del) {
	struct list *current, *previous;
	
	/* Again start from head->next, with the initial value of previous 
	 * pointing where head points (to the sentinel node) */
	for (previous = head, current = head->next; current != NULL && current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == NULL)
		return(1);
	
	previous->next = current->next;
	
	free(current);
	return(0);
}


int add_node (int input_data) {
	struct list *new_node;
	
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	new_node->data = input_data;
	
	/* Add the new node AFTER the sentinel */
	new_node->next = head->next;
	head->next = new_node;
	return(0);
}


/* We need to take care to release the memory allocated
 * for the sentinel node when the list is no longer needed */
void destroy_list(void) {
	free(head);
}

int main (int argc, char *argv[]) {
	int res;
	
	init_list();
		
	res = add_node(15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list();
	
	res = find_node(100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = remove_node(100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	destroy_list();
	return(0);	
}
