#include <stdlib.h>
#include <stdio.h>

/* Similar to a singly-linked list with sentinel, however now
 * the list is circular. Only the changes are highlighted with
 * comments */
struct list {
	int data;
	struct list *next;
};

struct list *head;

void init_list() {
	head = (struct list *)malloc(sizeof(struct list));
	if (head == NULL) {
		printf("Memory allocation error in initialization\n");
		exit(1);
	}
	/* The next pointer of the sentinel is initialized to point to
	 * itself (the list should be circular even when empty */
	head->next = head;
}


void print_list () {
	struct list *current;
	
	/* Stop scanning when you reach head */
	for (current = head->next; current != head; current = current->next) {
		printf("Node address %p, node data %d, node next %p\n", current, current->data, current->next);	
	}
}


int find_node (int search_data) {
	struct list *current;
	
	/* Put the value you are looking for in the data field of the 
	 * sentinel. Now search will stop after, at most, a full round
	   in the list. */
	head->data = search_data;
	for (current = head->next; current->data != search_data; current = current->next) {
	}
	/* If the value has been found in the sentinel, it was not actually
	 * in a real list node */
	if (current == head)
		return (0);
	else /* Otherwise, it was in a real list node */
		return (1);
}

int remove_node (int data_to_del) {
	struct list *current, *previous;
	
	/* Similarly to search, put the data looked for in sentinel and
	 * find out why you exited the following loop: because you found 
	 * a real node containing the data, or because you ran a full
	 * circle and found the data in the sentinel */
	head->data = data_to_del;
	for (previous = head, current = head->next; current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == head)
		return(1);
	
	previous->next = current->next;
	
	free(current);
	return(0);
}

int add_node (int input_data) {
	struct list *new_node;
	
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	new_node->data = input_data;
	new_node->next = head->next;
	
	head->next = new_node;
	return(0);
}

void destroy_list(void) {
	free(head);
}

int main (int argc, char *argv[]) {
	int res;
	
	init_list();
		
	res = add_node(15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list();
	
	res = find_node(100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = remove_node(100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	res = remove_node(20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list();
	
	destroy_list();
	return(0);	
}