#include <stdlib.h>
#include <stdio.h>

/* The struct representing a list node */
struct list {
	int data;
	struct list *next;
};


/* Initialization needs to be called before the first invocation 
 * of any lists function. The head of an empty list is NULL */
void init_list(struct list **list_head) {
	*list_head = NULL;
}


/* Scans the list and prints the contents of its nodes */
/* Recursive implementation ! */
void print_list (struct list *list_head) {
	struct list *current;
	
	/* Start from the node pointed to by head, and continue recursively 
	 * until you reach the end of the list (NULL next pointer) */
	if (list_head != NULL) {
		printf("Node address %p, node data %d, node next %p\n", 
			list_head, list_head->data, list_head->next);
		print_list(list_head->next);
	}
}


/* Find if there is a node in the list containing search_data.
 * Return 0 if not found, 1 if found */
/* Recursive implementation ! */
int find_node (struct list *list_head, int search_data) {
	if (list_head == NULL)
		return(0);
	if (list_head->data == search_data)
		return(1);
	else 
		return(find_node(list_head->next, search_data));
}


/* Look for a node containing data_to_del. If found, remove it.
 * Return 1 if the node was not found, 1 if the node was found
 * and deleted */
int remove_node (struct list **list_head, int data_to_del) {
	struct list *current, *previous;
	
	/* Apart from iterating through list nodes, at each step we need 
	 * to maintain a pointer to the previous node. This will be needed
	 * in the removal, if the node to be removed is found */
	for (previous = NULL, current = *list_head; current != NULL && current->data != data_to_del; previous = current, current = current->next) {
	}
	if (current == NULL)
		return(1);
	/* We have found the node */
	/* Removing the first node of the list is a special case. Just
	 * make the head point the the next node of the node removed */
	if (current == *list_head) {
		*list_head = current->next;
	}
	else { /* Otherwise (not the first node of the list) bypass the
		    * node to be removed by making the next pointer of its 
		    * previous node in the list point to the next node of the
		    * node to be removed */
		previous->next = current->next;
	}
	/* Now free the memory allocated for the node that we just 
	 * removed and return 0 */
	free(current);
	return(0);
}


/* Add a new node, containing input_data. Returns 0 if 
   successful, 1 otherwise */
int add_node (struct list **list_head, int input_data) {
	struct list *new_node, *current, *previous;
	
	/* Allocate memory for the new node */
	new_node = (struct list *)malloc(sizeof(struct list));
	if (new_node == NULL) {
		printf("Problem\n");
		return(1);
	}
	
	/* Store the data in the data field of the node */
	new_node->data = input_data;
	
	for (previous = NULL, current = *list_head; current != NULL && current->data < input_data; previous = current, current = current->next) {
	}
	
	if (current == *list_head) {
		new_node->next = *list_head;
		*list_head = new_node;
	}
	else {
		new_node->next = current;
		previous->next = new_node;
	}
	
	return(0);
}


/* Recursive deallocation of all nodes */
void destroy_list(struct list *list_head) {
	if (list_head != NULL) {
		printf("Entering destroy for list starting from node %p\n", list_head);
		destroy_list (list_head->next);
		printf("Going to free node %p\n", list_head);
		free(list_head);
	}
}

int main (int argc, char *argv[]) {
	int res;
	struct list *list1, *list2;
	
	init_list(&list1);
	init_list(&list2);
	
	res = add_node(&list1, 15);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list1, 20);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list1, 1);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	
	res = add_node(&list2, 16);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list2, 21);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	res = add_node(&list2, 2);
	if (res != 0) {
		printf("Problem in add_node\n");
		return(1);
	}
	
	print_list(list1);
	
	res = find_node(list1, 100);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");
	
	res = find_node(list1, 15);
	if (res == 0) 
		printf("Data not found\n");
	else
		printf("Data found\n");

	res = remove_node(&list1, 100);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");

	res = remove_node(&list1, 1);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	res = remove_node(&list1, 15);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	res = remove_node(&list1, 20);
	if (res == 0) 
		printf("Node deleted\n");
	else
		printf("Node not deleted\n");
	print_list(list1);
	
	print_list(list2);
	destroy_list(list2);
	list2 = NULL;
	print_list(list2);
	return(0);	
}
